
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

/**
 * Classe que representa o MIDlet do jogo
 * Deve implementar os metodos startApp(), 
 * pauseApp() e destroyApp().
 * Possui referncia para o controlador (thread) e
 * para a classe principal do jogo
 */
public class ShipMidlet extends MIDlet {

    /** Display da aplicao */
    public Display display = Display.getDisplay(this);

    /** Tela do jogo. Possui a lgica principal */
    private ShipGameScreen gameScreen;

    /** Controlador.  a thread que possui o looping do jogo */
    private ShipController controller;

    /** Instncia do midlet */
    private static ShipMidlet instance;

    /**
     * Construtor
     */
    public ShipMidlet() {
           instance = this;
    }

    /**
     * Retorna a instancia do jogo
     */
     public static ShipMidlet getInstance(){
       return instance;
     }

    /**
     * Ponto inicial da aplicao
     * Inicializa a classe principal do jogo e o controlador.
     */
    public void startApp() {
           //crias as instancias
           gameScreen = new ShipGameScreen();
           controller = new ShipController(gameScreen);

           //seta o listener da tela principal para ser o controler
           gameScreen.setCommandListener(controller);

           //inicializa o thread do jogo
           controller.init();

           //mostra a tela principal do jogo
           display.setCurrent(gameScreen);
    }

    /**
     * Mtodo invocado pela KVM no momento de uma interrupo externa.
     */
    public void pauseApp() {
        //pausa o jogo
        ShipController.setPaused(true);
    }

    /**
     * Mtodo da interface CommandListener que  chamado ao pressionamento
     * das softkeys que possuem comandos associados.
     *
     * @param cmd Comando que foi pressionado
     * @param s   Tela que disparou o comando
     */
    public void destroyApp(boolean parm1) {
           notifyDestroyed();
    }
}
